unit UHFReader188_Head;

interface

Const

    COM1 = 1;
    COM2 = 2;
    COM3 = 3;
    COM4 = 4;
    COM5 = 5;
    COM6 = 6;
    COM7 = 7;
    COM8 = 8;
    COM9 = 9;
    COM10 = 10;


    OK			    	= $00;

    NoElectronicTag     = $0e;
    OperationError      = $0f;



    OtherError             = $00;//
    MemoryOutPcNotSupport  = $03;//洢޻򲻱ֵ֧PCֵ
    MemoryLocked           = $04;//洢
    NoPower                = $0b;//Դ
    NotSpecialError        = $0f;//ض


    CmdNotIdentify                = $02;
    OperationNotSupport_          = $03;
    UnknownError                  = $0f;

  	AbnormalCommunication  = $02;

    CommunicationErr = $30;
    RetCRCErr        = $31;
    RetDataErr       = $32;    //ݳд
    CommunicationBusy= $33;
    ExecuteCmdBusy   = $34;
    ComPortOpened    = $35;
    ComPortClose     = $36;
    InvalidHandle    = $37;
    InvalidPort      = $38;
    RecmdErr         = $EE;    //ָ
    InventoryReturnEarly_G2   = $01;//ѯʱǰ
  	InventoryTimeOut_G2       = $02;// ָѯʱ
  	InventoryMoreData_G2      = $03; //Ϣ֮󣬻Ϣ
    ReadermoduleMCUFull_G2    = $04;// дģ洢ռ
  	AccessPasswordError          = $05;//
    DestroyPasswordError=$09; // 
    DestroyPasswordCannotZero=$0a; //벻Ϊȫ0
    TagNotSupportCMD=$0b;// ӱǩָ֧
    AccessPasswordCannotZero=$0c;// Ը벻Ϊȫ0
    TagProtectedCannotSetAgain=$0d;//ӱǩѾ˶ٴ
    TagNoProtectedDonotNeedUnlock=$0e;//  ӱǩûбöҪ
    ByteLockedWriteFail=$10;//  ֽڿռ䱻дʧ
    CannotLock=$11;// 
    LockedCannotLockAgain=$12;// Ѿٴ
    ParameterSaveFailCanUseBeforeNoPower=$13;// ʧ,õֵڶдģϵǰЧ
    CannotAdjust=$14;//޷
    InventoryReturnEarly_6B=$15;// ѯʱǰ
    InventoryTimeOut_6B=$16;//ָѯʱ
    InventoryMoreData_6B=$17;// Ϣ֮󣬻Ϣ
    ReadermoduleMCUFull_6B=$18;// дģ洢ռ
    NotSupportCMDOrAccessPasswordCannotZero=$19;  //Ӳָ֧߷벻Ϊ0
    CMDExecuteErr=$F9;// ִг
    GetTagPoorCommunicationCannotOperation=$FA; //еӱǩͨŲ޷
    NoTagOperation=$FB; //޵ӱǩɲ
    TagReturnErrorCode=$FC;// ӱǩش
    CMDLengthWrong=$FD;// ȴ
    IllegalCMD=$FE;//Ϸ
    ParameterError=$FF;// 

    Function UHFReader188_GetErrorCodeDesc(errorCode : Byte) : String;
    Function UHFReader188_GetReturnCodeDesc(retCode : Byte) : String;
    Function GeteCodeDesc(retCode : string) : String;

implementation

Function GeteCodeDesc(retCode : string) : String;
begin
    result := '';
    if(retCode='C')then
    begin
       result := '';
    end
    else if(retCode='R')then
    begin
      Result:='豸ִܾ';
    end
    else if(retCode='D')then
    begin
      Result:='豸Ӳ';
    end
    else if(retCode='F') then
    begin
      Result:='ִʧ';
    end;
end;
Function UHFReader188_GetErrorCodeDesc(errorCode : Byte) : String;
begin
    result := '';
    case errorCode of
        OtherError            : result := ' ȫ׽δ븲ǵĴ';
        MemoryOutPcNotSupport : result := '洢޻򲻱ֵ֧PCֵ 涨洢λòڻǩ֧PCֵ';
        MemoryLocked          : result := '洢 洢λҲд';
        NoPower               : result := 'Դ ǩԴ㣬޷ִд洢д';
        NotSpecialError       : result := 'ض ǩ֧ض';

    end;
end;

Function UHFReader188_GetReturnCodeDesc(retCode : Byte) : String;
begin
    result := '';
    case retCode of
        InventoryReturnEarly_G2               : result := 'ѯʱǰ';
        InventoryTimeOut_G2                   : result := 'ָѯʱ';
        InventoryMoreData_G2                  : result := 'Ϣ֮󣬻Ϣ';
        ReadermoduleMCUFull_G2                : result := 'дģ洢ռ';
        AccessPasswordError                   : result := '';
        DestroyPasswordError                  : result := '';
        DestroyPasswordCannotZero             : result := '벻Ϊȫ0';
        TagNotSupportCMD                      : result := 'ӱǩָ֧';
        AccessPasswordCannotZero              : result := 'Ը벻Ϊȫ0';
        TagProtectedCannotSetAgain            : result := 'ӱǩѾ˶ٴ';
        TagNoProtectedDonotNeedUnlock         : result := 'ӱǩûбöҪ';
        ByteLockedWriteFail                   : result := 'ֽڿռ䱻дʧ';
        CannotLock                            : result := '';
        LockedCannotLockAgain                 : result := 'Ѿٴ';
        ParameterSaveFailCanUseBeforeNoPower  : result := 'ʧ,õֵڶдģϵǰЧ';
        CannotAdjust                          : result := '޷';
        InventoryReturnEarly_6B               : result := 'ѯʱǰ';
        InventoryTimeOut_6B                   : result := 'ָѯʱ';
        InventoryMoreData_6B                  : result := 'Ϣ֮󣬻Ϣ';
        ReadermoduleMCUFull_6B                : result := 'дģ洢ռ';
        NotSupportCMDOrAccessPasswordCannotZero : result := 'Ӳָ֧߷벻Ϊ0';
        GetTagPoorCommunicationCannotOperation: result := 'еӱǩͨŲ޷';
        NoTagOperation                        : result := '޵ӱǩɲ';
        TagReturnErrorCode                    : result := 'ӱǩش';
        CMDLengthWrong                        : result := 'ȴ';
        IllegalCMD                            : result := 'Ϸ';
        ParameterError                        : result := '';


        RecmdErr            : result := 'ָ';
        CommunicationErr    : result := 'ͨѶ';
        RetCRCErr           : result := 'CRCУ';
        RetDataErr          : result := 'ݳд';
        CommunicationBusy   : result := 'ͨѶæ豸ִָ';
        ExecuteCmdBusy      : result := 'æִָ';
        ComPortOpened       : result := '˿Ѵ';
        ComPortClose        : result := '˿ѹر';
        InvalidHandle       : result := 'Ч';
        InvalidPort         : result := 'Ч˿';
        $F8         : result := 'Ӽ';
    end;
end;

end.
